<?php
namespace Elementor;

use \ElementsKit\Elementskit_Widget_Header_Search_Handler as Handler;
use \ElementsKit\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;


class Elementskit_Widget_Header_Search extends Widget_Base
{

    public $base;

    public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );
		$this->add_script_depends('magnific-popup');
	}

    public function get_name() {
        return Handler::get_name();
    }

    public function get_title() {
        return Handler::get_title();
    }

    public function get_icon() {
        return Handler::get_icon();
    }

    public function get_categories() {
        return Handler::get_categories();
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'ekit_header_search',
            [
                'label' => esc_html__('Header Search', 'elementskit'),
            ]
        );


        $this->add_control(
            'ekit_search_icon',
            [
                'label' => esc_html__('Select Icon', 'elementskit'),
                'label_block' => true,
                'type' => Controls_Manager::ICON,
                'default' => 'icon icon-search',

            ]
        );

        $this->add_responsive_control(
            'ekit_search_icon_font_size',
            [
                'label'         => esc_html__('Font Size', 'elementskit'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em'],
                'default' => [
                    'unit' => 'px',
                    'size' => '20',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekit_navsearch-button' => 'font-size: {{SIZE}}{{UNIT}};',
                ],

            ]
        );


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'ekit_border',
                'selector' => '{{WRAPPER}} .ekit_navsearch-button',
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs( 'ekit_search_tab_search_tabs' );
            $this->start_controls_tab(
                'ekit_search_tab_search_normal',
                [
                    'label' =>esc_html__( 'Normal', 'elementskit' ),
                ]
            );
            $this->add_control(
                'ekit_searech_icon_color',
                [
                    'label' =>esc_html__( 'Color', 'elementskit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .ekit_navsearch-button' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'ekit_seacrh_icon_bg_color',
                [
                    'label' =>esc_html__( 'Background Color', 'elementskit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .ekit_navsearch-button' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->end_controls_tab();
            
            $this->start_controls_tab(
                'ekit_search_tab_search_hover',
                [
                    'label' =>esc_html__( 'Hover', 'elementskit' ),
                ]
            );
            $this->add_control(
                'ekit_searech_icon_hover_color',
                [
                    'label' =>esc_html__( 'Color', 'elementskit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .ekit_navsearch-button:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'ekit_seacrh_icon_hover_bg_color',
                [
                    'label' =>esc_html__( 'Background Color', 'elementskit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .ekit_navsearch-button:hover' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'ekit_header_search_section_tab_style',
            [
                'label' => esc_html__('Header Search', 'elementskit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        // box shadow
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'       => 'ekit_header_search',
                'selector'   => '{{WRAPPER}} .ekit_navsearch-button',

            ]
        );
        // border radius
        $this->add_control(
            'ekit_header_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'elementskit' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50' ,
                    'left' => '50',
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekit_navsearch-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'ekit_search_margin',
            [
                'label'         => esc_html__('Margin', 'elementskit'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5' ,
                    'left' => '5',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekit_navsearch-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'ekit_search_padding',
			[
				'label' => __( 'Padding', 'elementskit' ),
				'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0' ,
                    'left' => '0',
                ],
				'selectors' => [
					'{{WRAPPER}} .ekit_navsearch-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


        $this->add_control(
			'ekit_search_height_width_socher',
			[
				'label' => __( 'Use Height Width', 'elementskit' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementskit' ),
				'label_off' => __( 'Hide', 'elementskit' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_responsive_control(
            'ekit_search_width',
            [
                'label'         => esc_html__('Width', 'elementskit'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%'],
                'default' => [
                    'unit' => 'px',
                    'size' => '40',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekit_navsearch-button' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'ekit_search_height_width_socher' => 'yes'
                ]
            ]
        );
        $this->add_responsive_control(
            'ekit_search_height',
            [
                'label'         => esc_html__('Height', 'elementskit'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%'],
                'default' => [
                    'unit' => 'px',
                    'size' => '40',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekit_navsearch-button' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'ekit_search_height_width_socher' => 'yes'
                ]
            ]
        );
        $this->add_responsive_control(
            'ekit_search_line_height',
            [
                'label'         => esc_html__('Line Height', 'elementskit'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%'],
                'default' => [
                    'unit' => 'px',
                    'size' => '40',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekit_navsearch-button' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'ekit_search_height_width_socher' => 'yes'
                ]
            ]
        );
        $this->add_responsive_control(
            'ekit_search_icon_text_align',
            [
                'label' => esc_html__( 'Alignment', 'elementskit' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementskit' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementskit' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementskit' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .ekit_navsearch-button' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

    }


    protected function render( ) {
        echo '<div class="ekit-wid-con" >';
            $this->render_raw();
        echo '</div>';
    }

    protected function render_raw( ) {
        $settings = $this->get_settings();
        ?>
        <a href="#ekit_modal-popup-<?php echo esc_attr($this->get_id()); ?>" class="ekit_navsearch-button ekit-modal-popup"><i
                    class="<?php echo esc_attr($settings['ekit_search_icon']);?>"></i></a>
        <!-- language switcher strart -->
        <!-- xs modal -->
        <div class="zoom-anim-dialog mfp-hide ekit_modal-searchPanel" id="ekit_modal-popup-<?php echo esc_attr($this->get_id()); ?>">
            <div class="ekit-search-panel">
                <form role="search" method="get" class="ekit-search-group" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <input type="search" class="ekit_search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'elementskit' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
                    <button type="submit" class="ekit_search-button"><i class="icon icon-search"></i></button>
                </form>
            </div>
        </div><!-- End xs modal -->
        <!-- end language switcher strart -->
        <?php




    }
    protected function _content_template() { }






}